/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#include "DescriptorManager.h"
#include _DRIVER_

DescriptorManager::DescriptorManager() {

    itemIn ein;
    itemOut eout;
    int cantb, cantd, *iserial;
    dscEndpoint *endp;

    l = log::instance();
    dl = new _DRIVER();

    // Inicializo el mapa SerialNumber -> IdBoard
    iserial = dl->getU4ABoards(cantb);
    for (int i = 0; i < cantb ; i++) {
        serials.insert(pair<int,int>(iserial[i],i));
    };
    delete [] iserial;

    // Cargo los tipos de descriptores de cada placa detectada.
    for (int i = 0; i < cantb ; i++) {
        cantd = dl->qtyDsc(i);
        for (int j = 0 ; j < cantd ; j++) {
            endp = dl->getEndpointDsc(i, j);
            if (endp->tdscin != NULL_IN) {
                ein.dsc = endp->epnum;
                ein.tin = endp->tdscin;
                ein.cantAsignados = 0;
                ein.buffer = dl->openIn(i, ein.dsc, ein.tin);
                dscIn.insert(pair<int,itemIn>(i,ein));
            }
            else {
                eout.dsc = endp->epnum;
                eout.tout = endp->tdscout;
                eout.cantAsignados = 0;
                eout.buffer = dl->openOut(i, eout.dsc, eout.tout);
                dscOut.insert(pair<int,itemOut>(i,eout));
            }
            delete endp;
        }
    }
}

DescriptorManager::~DescriptorManager() {

    multimap<int,itemIn>::iterator it1;
    multimap<int,itemOut>::iterator it2;
    l = NULL;

    for (it1 = dscIn.begin() ; it1 != dscIn.end(); it1++ ) {
        dl->close(it1->second.buffer);
    }
    for (it2 = dscOut.begin() ; it2 != dscOut.end(); it2++ ) {
        dl->close(it2->second.buffer);
    }
    delete dl;
}

int DescriptorManager::requestDscIn(int serial, int tdsc) {

    multimap<int,itemIn>::iterator it;
    int board;

    board = getInstanceBoard(serial);
    for (it = dscIn.begin() ; it != dscIn.end(); it++ ) {
        if (it->first == board) {
            if (it->second.tin == tdsc) {
                it->second.cantAsignados =+ 1;
                return it->second.dsc;
            }
        }
    }
    return HNDERROR;
}

int DescriptorManager::requestDscOut(int serial, int tdsc) {

    multimap<int,itemOut>::iterator it;
    int board;

    board = getInstanceBoard(serial);
    for (it = dscOut.begin() ; it != dscOut.end(); it++ ) {
        if (it->first == board) {
            if (it->second.tout == tdsc) {
                it->second.cantAsignados =+ 1;
                return it->second.dsc;
            }
        }
    }
    return HNDERROR;
}

void DescriptorManager::freeDscIn(int serial, int dsc) {

    multimap<int,itemIn>::iterator it;
    int board;

    board = getInstanceBoard(serial);
    for (it = dscIn.begin() ; it != dscIn.end(); it++ ) {
        if ((it->first == board) && (it->second.dsc == dsc) && (it->second.cantAsignados > 0)) {
            it->second.cantAsignados =- 1;
            break;
        }
    }
}

void DescriptorManager::freeDscOut(int serial, int dsc) {

    multimap<int,itemOut>::iterator it;
    int board;

    board = getInstanceBoard(serial);
    for (it = dscOut.begin() ; it != dscOut.end(); it++ ) {
        if ((it->first == board) && (it->second.dsc == dsc) && (it->second.cantAsignados > 0)) {
            it->second.cantAsignados =- 1;
            break;
        }
    }
}

int DescriptorManager::getBufferIn(int board, int dsc) {

    multimap<int,itemIn>::iterator it;

    for (it = dscIn.begin();it != dscIn.end();it++) {
        if ((it->first == board) && (it->second.dsc == dsc)) {
            return it->second.buffer;
        }
    }
    return HNDERROR;
}

int DescriptorManager::getBufferOut(int board, int dsc) {

    multimap<int,itemOut>::iterator it;

    for (it = dscOut.begin();it != dscOut.end();it++) {
        if ((it->first == board) && (it->second.dsc == dsc)) {
            return it->second.buffer;
        }
    }
    return HNDERROR;
}

int DescriptorManager::getTypeDscIn(int board, int dsc) {

    multimap<int,itemIn>::iterator it;

    for (it = dscIn.begin(); it != dscIn.end();it++) {
        if ((it->first == board) && (it->second.dsc == dsc)) {
            return it->second.tin;
        }
    }
    return NULL_IN;
}

int DescriptorManager::getTypeDscOut(int board, int dsc) {

    multimap<int, itemOut>::iterator it;

    for (it = dscOut.begin(); it != dscOut.end();it++) {
        if ((it->first == board) && (it->second.dsc == dsc)) {
            return it->second.tout;
        }
    }
    return NULL_OUT;
}

bool DescriptorManager::send(int serial, int dsc, char *msg, int nlen, int timeout) {

    int board = getInstanceBoard(serial);
    int nbuff = getBufferOut(board, dsc);
    int tout = getTypeDscOut(board, dsc);

    switch (tout) {
        case BULK_OUT:
            return dl->sendBulk(nbuff, msg, nlen, timeout);
            break;
        case CTRL_OUT:
            return dl->sendCtrl(nbuff, msg, nlen, timeout);
            break;
        case INT_OUT:
            return dl->sendInt(nbuff, msg, nlen, timeout);
            break;
        case ISO_OUT:
            return dl->sendIso(nbuff, msg, nlen, timeout);
            break;
        case NULL_OUT:
            return false;
            break;
     }
     return false;
}

char* DescriptorManager::receive(int serial, int dsc, int& recv, bool& ok, int timeout) {

    int board = getInstanceBoard(serial);
    int nbuff = getBufferIn(board, dsc);
    int tin = getTypeDscIn(board, dsc);

    switch (tin) {
        case BULK_IN:
            return dl->receiveBulk(nbuff, recv, ok, timeout);
            break;
        case CTRL_IN:
            return dl->receiveCtrl(nbuff, recv, ok, timeout);
            break;
        case INT_IN:
            return dl->receiveInt(nbuff, recv, ok, timeout);
            break;
        case ISO_IN:
            return dl->receiveIso(nbuff, recv, ok, timeout);
            break;
        case NULL_IN:
            return NULL;
            break;
    }
    return NULL;
}

int* DescriptorManager::getU4ABoards(int &cant) {

    map<int,int>::iterator it;
    int* boards;

    cant = serials.size();
    boards = new int[cant];
    for (it = serials.begin(); it != serials.end();it++) {
        boards[it->second] = it->first;
    }
    return boards;
}

int DescriptorManager::getInstanceBoard(int serial) {

    map<int,int>::iterator it;

    it = serials.find(serial);
    return (it->second);
}
